<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BankRequest;
use PaypalServerSdkLib\Models\SetupTokenRequestCard;
use PaypalServerSdkLib\Models\SetupTokenRequestPaymentSource;
use PaypalServerSdkLib\Models\VaultApplePayRequest;
use PaypalServerSdkLib\Models\VaultPaypalWalletRequest;
use PaypalServerSdkLib\Models\VaultTokenRequest;
use PaypalServerSdkLib\Models\VaultVenmoRequest;

/**
 * Builder for model SetupTokenRequestPaymentSource
 *
 * @see SetupTokenRequestPaymentSource
 */
class SetupTokenRequestPaymentSourceBuilder
{
    /**
     * @var SetupTokenRequestPaymentSource
     */
    private $instance;

    private function __construct(SetupTokenRequestPaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Setup Token Request Payment Source Builder object.
     */
    public static function init(): self
    {
        return new self(new SetupTokenRequestPaymentSource());
    }

    /**
     * Sets card field.
     *
     * @param SetupTokenRequestCard|null $value
     */
    public function card(?SetupTokenRequestCard $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets paypal field.
     *
     * @param VaultPaypalWalletRequest|null $value
     */
    public function paypal(?VaultPaypalWalletRequest $value): self
    {
        $this->instance->setPaypal($value);
        return $this;
    }

    /**
     * Sets venmo field.
     *
     * @param VaultVenmoRequest|null $value
     */
    public function venmo(?VaultVenmoRequest $value): self
    {
        $this->instance->setVenmo($value);
        return $this;
    }

    /**
     * Sets apple pay field.
     *
     * @param VaultApplePayRequest|null $value
     */
    public function applePay(?VaultApplePayRequest $value): self
    {
        $this->instance->setApplePay($value);
        return $this;
    }

    /**
     * Sets token field.
     *
     * @param VaultTokenRequest|null $value
     */
    public function token(?VaultTokenRequest $value): self
    {
        $this->instance->setToken($value);
        return $this;
    }

    /**
     * Sets bank field.
     *
     * @param BankRequest|null $value
     */
    public function bank(?BankRequest $value): self
    {
        $this->instance->setBank($value);
        return $this;
    }

    /**
     * Initializes a new Setup Token Request Payment Source object.
     */
    public function build(): SetupTokenRequestPaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
